/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.junglemobs.entity;

import com.lycanitesmobs.ObjectManager;
import com.lycanitesmobs.api.IGroupAnimal;
import com.lycanitesmobs.api.IGroupPredator;
import com.lycanitesmobs.api.IGroupPrey;
import com.lycanitesmobs.core.config.ConfigBase;
import com.lycanitesmobs.core.entity.EntityCreatureAgeable;
import com.lycanitesmobs.core.entity.EntityCreatureBase;
import com.lycanitesmobs.core.entity.ai.EntityAIAttackMelee;
import com.lycanitesmobs.core.entity.ai.EntityAILookIdle;
import com.lycanitesmobs.core.entity.ai.EntityAIStayByHome;
import com.lycanitesmobs.core.entity.ai.EntityAISwimming;
import com.lycanitesmobs.core.entity.ai.EntityAITargetAttack;
import com.lycanitesmobs.core.entity.ai.EntityAITargetMasterAttack;
import com.lycanitesmobs.core.entity.ai.EntityAIWander;
import com.lycanitesmobs.core.entity.ai.EntityAIWatchClosest;
import com.lycanitesmobs.core.info.DropRate;
import com.lycanitesmobs.junglemobs.entity.EntityConba;
import com.lycanitesmobs.junglemobs.entity.EntityVespid;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.passive.IAnimals;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;

public class EntityVespidQueen
extends EntityCreatureAgeable
implements IMob,
IGroupPredator {
    public boolean inHiveCache = false;
    private int hiveCheckCacheTime = 0;
    public List<HiveExposedCoordinates> hiveExposedBlocks = new ArrayList<HiveExposedCoordinates>();
    private int hiveExposedBlockCacheTime = 0;
    private int vespidQueenSwarmLimit = 10;
    private boolean vespidHiveBuilding = true;

    public EntityVespidQueen(World world) {
        super(world);
        this.attribute = EnumCreatureAttribute.ARTHROPOD;
        this.defense = 1;
        this.experience = 5;
        this.hasAttackSound = true;
        this.setWidth = 1.6f;
        this.setHeight = 1.9f;
        this.solidCollision = true;
        this.setupMob();
        this.canGrow = true;
        this.babySpawnChance = 0.0;
        this.field_70138_W = 1.0f;
        this.justAttackedTime = (short)10;
        this.vespidQueenSwarmLimit = ConfigBase.getConfig(this.group, "general").getInt("Features", "Vespid Queen Swarm Limit", this.vespidQueenSwarmLimit, "Limits how many Vespid drones a Queen can have before she will no longer spawn babies in hives.");
        this.vespidHiveBuilding = ConfigBase.getConfig(this.group, "general").getBool("Features", "Vespid Hive Building", this.vespidHiveBuilding, "Set to false to stop Vespids from building hives all together.");
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming(this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIAttackMelee(this).setRate(10).setLongMemory(true));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIStayByHome(this));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIWander(this).setPauseRate(1200));
        this.field_70714_bg.func_75776_a(10, (EntityAIBase)new EntityAIWatchClosest(this).setTargetClass(EntityPlayer.class));
        this.field_70714_bg.func_75776_a(11, (EntityAIBase)new EntityAILookIdle(this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAITargetMasterAttack(this));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAITargetAttack(this).setTargetClass(EntityConba.class));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAITargetAttack(this).setTargetClass(EntityVespidQueen.class));
        this.field_70715_bh.func_75776_a(4, (EntityAIBase)new EntityAITargetAttack(this).setTargetClass(EntityVespid.class));
        this.field_70715_bh.func_75776_a(4, (EntityAIBase)new EntityAITargetAttack(this).setTargetClass(IGroupPrey.class));
        this.field_70715_bh.func_75776_a(4, (EntityAIBase)new EntityAITargetAttack(this).setTargetClass(IAnimals.class));
        this.field_70715_bh.func_75776_a(4, (EntityAIBase)new EntityAITargetAttack(this).setTargetClass(IGroupAnimal.class));
        this.field_70715_bh.func_75776_a(4, (EntityAIBase)new EntityAITargetAttack(this).setTargetClass(EntityPlayer.class));
        this.field_70715_bh.func_75776_a(4, (EntityAIBase)new EntityAITargetAttack(this).setTargetClass(EntityVillager.class));
    }

    @Override
    protected void func_110147_ax() {
        HashMap<String, Double> baseAttributes = new HashMap<String, Double>();
        baseAttributes.put("maxHealth", 20.0);
        baseAttributes.put("movementSpeed", 0.28);
        baseAttributes.put("knockbackResistance", 0.25);
        baseAttributes.put("followRange", 24.0);
        baseAttributes.put("attackDamage", 2.0);
        super.applyEntityAttributes(baseAttributes);
    }

    @Override
    public void loadItemDrops() {
        this.drops.add(new DropRate(new ItemStack(Items.field_151119_aD), 0.5f).setMaxAmount(16));
        this.drops.add(new DropRate(new ItemStack(ObjectManager.getBlock("propolis")), 0.5f).setMaxAmount(8));
        this.drops.add(new DropRate(new ItemStack(ObjectManager.getBlock("veswax")), 0.5f).setMaxAmount(8));
    }

    @Override
    public boolean isPersistant() {
        if (this.hasHome() && this.func_130014_f_().func_175659_aa() != EnumDifficulty.PEACEFUL) {
            return true;
        }
        return super.isPersistant();
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (this.vespidHiveBuilding) {
            --this.hiveCheckCacheTime;
            if (this.hiveCheckCacheTime < 0) {
                this.hiveCheckCacheTime = 0;
            }
            --this.hiveExposedBlockCacheTime;
            if (this.hiveExposedBlockCacheTime < 0) {
                this.hiveExposedBlockCacheTime = 0;
            }
            if (!this.func_130014_f_().field_72995_K && !this.hasHome() && this.hiveFoundationsSet()) {
                this.setHome((int)this.field_70165_t, (int)this.field_70163_u, (int)this.field_70161_v, 16.0f);
            }
            if (!this.func_130014_f_().field_72995_K && this.hiveFoundationsSet() && this.field_70173_aa % 60 == 0) {
                this.allyUpdate();
            }
        }
        if (!this.func_130014_f_().field_72995_K && this.func_70638_az() instanceof EntityConba && ((EntityConba)this.func_70638_az()).vespidInfection) {
            this.func_70624_b(null);
        }
    }

    public void allyUpdate() {
        EntityLivingBase minion;
        float random;
        if (this.func_130014_f_().field_72995_K) {
            return;
        }
        if (this.vespidQueenSwarmLimit > 0 && this.nearbyCreatureCount(EntityVespid.class, 32.0) < this.vespidQueenSwarmLimit && (random = this.field_70146_Z.nextFloat()) <= 0.05f && (minion = this.spawnAlly(this.field_70165_t - 2.0 + (double)(random * 4.0f), this.field_70163_u, this.field_70161_v - 2.0 + (double)(random * 4.0f))) instanceof EntityCreatureAgeable) {
            ((EntityCreatureAgeable)minion).setGrowingAge(((EntityCreatureAgeable)minion).growthTime);
        }
    }

    public EntityLivingBase spawnAlly(double x, double y, double z) {
        EntityVespid minion = new EntityVespid(this.func_130014_f_());
        minion.func_70012_b(x, y, z, this.field_70146_Z.nextFloat() * 360.0f, 0.0f);
        if (minion instanceof EntityCreatureBase) {
            ((EntityCreatureBase)minion).setSubspecies(this.getSubspeciesIndex(), true);
        }
        this.func_130014_f_().func_72838_d((Entity)minion);
        if (this.func_70638_az() != null) {
            minion.func_70604_c(this.func_70638_az());
        }
        return minion;
    }

    public BlockPos getHivePosition() {
        if (this.hasHome()) {
            return this.getHomePosition();
        }
        return this.func_180425_c();
    }

    public boolean hiveFoundationsSet() {
        return this.hiveFoundationsSet(false);
    }

    public boolean hiveFoundationsSet(boolean clearCache) {
        if (clearCache || this.hiveCheckCacheTime <= 0) {
            this.hiveCheckCacheTime = 100;
            if (!this.doesHiveHaveXPositive()) {
                this.inHiveCache = false;
                return false;
            }
            if (!this.doesHiveHaveXNegative()) {
                this.inHiveCache = false;
                return false;
            }
            if (!this.doesHiveHaveYPositive()) {
                this.inHiveCache = false;
                return false;
            }
            if (!this.doesHiveHaveYNegative()) {
                this.inHiveCache = false;
                return false;
            }
            if (!this.doesHiveHaveZPositive()) {
                this.inHiveCache = false;
                return false;
            }
            if (!this.doesHiveHaveZNegative()) {
                this.inHiveCache = false;
                return false;
            }
            this.inHiveCache = true;
            return true;
        }
        return this.inHiveCache;
    }

    public boolean isHiveBlock(BlockPos searchPos) {
        return this.isHiveWall(searchPos) || this.isHiveFloor(searchPos);
    }

    public boolean isHiveWall(BlockPos searchPos) {
        IBlockState searchState = this.func_130014_f_().func_180495_p(searchPos);
        Block searchBlock = searchState.func_177230_c();
        return searchBlock != null && searchBlock == ObjectManager.getBlock("veswax") && searchBlock.func_176201_c(searchState) < 8;
    }

    public boolean isHiveFloor(BlockPos searchPos) {
        IBlockState searchState = this.func_130014_f_().func_180495_p(searchPos);
        Block searchBlock = searchState.func_177230_c();
        return searchBlock != null && searchBlock == ObjectManager.getBlock("propolis") && searchBlock.func_176201_c(searchState) < 8;
    }

    public boolean doesHiveHaveXPositive() {
        BlockPos hivePos = this.getHivePosition();
        for (int x = hivePos.func_177958_n(); x <= hivePos.func_177958_n() + 28; ++x) {
            if (!this.isHiveWall(new BlockPos(x, hivePos.func_177956_o(), hivePos.func_177952_p()))) continue;
            return true;
        }
        return false;
    }

    public boolean doesHiveHaveXNegative() {
        BlockPos hivePos = this.getHivePosition();
        for (int x = hivePos.func_177958_n(); x >= hivePos.func_177958_n() - 28; --x) {
            if (!this.isHiveWall(new BlockPos(x, hivePos.func_177956_o(), hivePos.func_177952_p()))) continue;
            return true;
        }
        return false;
    }

    public boolean doesHiveHaveYPositive() {
        BlockPos hivePos = this.getHivePosition();
        for (int y = hivePos.func_177956_o(); y <= hivePos.func_177956_o() + 28; ++y) {
            if (!this.isHiveFloor(new BlockPos(hivePos.func_177958_n(), y, hivePos.func_177952_p()))) continue;
            return true;
        }
        return false;
    }

    public boolean doesHiveHaveYNegative() {
        BlockPos hivePos = this.getHivePosition();
        for (int y = hivePos.func_177956_o(); y >= hivePos.func_177956_o() - 28; --y) {
            if (!this.isHiveFloor(new BlockPos(hivePos.func_177958_n(), y, hivePos.func_177952_p()))) continue;
            return true;
        }
        return false;
    }

    public boolean doesHiveHaveZPositive() {
        BlockPos hivePos = this.getHivePosition();
        for (int z = hivePos.func_177952_p(); z <= hivePos.func_177952_p() + 28; ++z) {
            if (!this.isHiveWall(new BlockPos(hivePos.func_177958_n(), hivePos.func_177956_o(), z))) continue;
            return true;
        }
        return false;
    }

    public boolean doesHiveHaveZNegative() {
        BlockPos hivePos = this.getHivePosition();
        for (int z = hivePos.func_177952_p(); z >= hivePos.func_177952_p() - 28; --z) {
            if (!this.isHiveWall(new BlockPos(hivePos.func_177958_n(), hivePos.func_177956_o(), z))) continue;
            return true;
        }
        return false;
    }

    public List<HiveExposedCoordinates> getHiveExposureBlocks() {
        if (this.hiveExposedBlockCacheTime <= 0) {
            this.hiveExposedBlockCacheTime = 200;
            this.hiveExposedBlocks = new ArrayList<HiveExposedCoordinates>();
            BlockPos hivePos = this.getHivePosition();
            int hiveMax = 28;
            for (int x = hivePos.func_177958_n() - hiveMax; x <= hivePos.func_177958_n() + hiveMax; ++x) {
                for (int y = hivePos.func_177956_o() - hiveMax; y <= hivePos.func_177956_o() + hiveMax; ++y) {
                    for (int z = hivePos.func_177952_p() - hiveMax; z <= hivePos.func_177952_p() + hiveMax; ++z) {
                        BlockPos checkPos = new BlockPos(x, y, z);
                        if (!this.isHiveBlock(checkPos)) continue;
                        IBlockState state = this.func_130014_f_().func_180495_p(checkPos);
                        Block block = state.func_177230_c();
                        int orientationMeta = block.func_176201_c(state);
                        EnumFacing facing = EnumFacing.func_82600_a((int)orientationMeta);
                        if (facing.func_82601_c() == 0) {
                            if (!this.isHiveBlock(checkPos.func_177982_a(-1, 0, 0)) && this.canPlaceBlockAt(checkPos.func_177982_a(-1, 0, 0))) {
                                this.hiveExposedBlocks.add(new HiveExposedCoordinates(block, checkPos.func_177982_a(-1, 0, 0), orientationMeta));
                            }
                            if (!this.isHiveBlock(checkPos.func_177982_a(1, 0, 0)) && this.canPlaceBlockAt(checkPos.func_177982_a(1, 0, 0))) {
                                this.hiveExposedBlocks.add(new HiveExposedCoordinates(block, checkPos.func_177982_a(1, 0, 0), orientationMeta));
                            }
                        }
                        if (facing.func_96559_d() == 0) {
                            if (!this.isHiveBlock(checkPos.func_177982_a(0, -1, 0)) && this.canPlaceBlockAt(checkPos.func_177982_a(0, -1, 0))) {
                                this.hiveExposedBlocks.add(new HiveExposedCoordinates(block, checkPos.func_177982_a(0, -1, 0), orientationMeta));
                            }
                            if (!this.isHiveBlock(checkPos.func_177982_a(0, 1, 0)) && this.canPlaceBlockAt(checkPos.func_177982_a(0, 1, 0))) {
                                this.hiveExposedBlocks.add(new HiveExposedCoordinates(block, checkPos.func_177982_a(0, 1, 0), orientationMeta));
                            }
                        }
                        if (facing.func_82599_e() != 0) continue;
                        if (!this.isHiveBlock(checkPos.func_177982_a(0, 0, -1)) && this.canPlaceBlockAt(checkPos.func_177982_a(0, 0, -1))) {
                            this.hiveExposedBlocks.add(new HiveExposedCoordinates(block, checkPos.func_177982_a(0, 0, -1), orientationMeta));
                        }
                        if (this.isHiveBlock(checkPos.func_177982_a(0, 0, 1)) || !this.canPlaceBlockAt(checkPos.func_177982_a(0, 0, 1))) continue;
                        this.hiveExposedBlocks.add(new HiveExposedCoordinates(block, checkPos.func_177982_a(0, 0, 1), orientationMeta));
                    }
                }
            }
        }
        return this.hiveExposedBlocks;
    }

    public boolean canPlaceBlockAt(BlockPos pos) {
        IBlockState targetState = this.func_130014_f_().func_180495_p(pos);
        Block targetBlock = targetState.func_177230_c();
        if (targetBlock == null) {
            return false;
        }
        if (targetBlock == Blocks.field_150350_a) {
            return true;
        }
        return targetState.func_185904_a() == Material.field_151586_h || targetState.func_185904_a() == Material.field_151587_i;
    }

    @Override
    public boolean meleeAttack(Entity target, double damageScale) {
        if (target instanceof EntityConba) {
            ((EntityConba)target).vespidInfection = true;
            return true;
        }
        if (!super.meleeAttack(target, damageScale)) {
            return false;
        }
        if (target instanceof EntityLivingBase) {
            int effectSeconds = 16;
            if (target instanceof EntityPlayer) {
                effectSeconds = (byte)(effectSeconds / 2);
            }
            ((EntityLivingBase)target).func_70690_d(new PotionEffect(MobEffects.field_76436_u, this.getEffectDuration(effectSeconds), 0));
        }
        return true;
    }

    @Override
    public boolean canAttackEntity(EntityLivingBase targetEntity) {
        if (targetEntity instanceof EntityConba && ((EntityConba)targetEntity).vespidInfection) {
            return false;
        }
        if (targetEntity instanceof EntityVespid && (!((EntityVespid)targetEntity).hasMaster() || ((EntityVespid)targetEntity).getMasterTarget() == this)) {
            return false;
        }
        return super.canAttackEntity(targetEntity);
    }

    @Override
    public boolean isFlying() {
        return true;
    }

    @Override
    public float getDamageModifier(DamageSource damageSrc) {
        if (damageSrc.func_76347_k()) {
            return 4.0f;
        }
        return 1.0f;
    }

    @Override
    public boolean func_70687_e(PotionEffect potionEffect) {
        if (potionEffect.func_188419_a() == MobEffects.field_76436_u) {
            return false;
        }
        if (potionEffect.func_188419_a() == MobEffects.field_76421_d) {
            return false;
        }
        return super.func_70687_e(potionEffect);
    }

    @Override
    public boolean isDamageTypeApplicable(String type) {
        if (type.equals("inWall")) {
            return false;
        }
        return super.isDamageTypeApplicable(type);
    }

    public class HiveExposedCoordinates {
        public Block block;
        public BlockPos pos;
        public int orientationMeta;

        public HiveExposedCoordinates(Block block, BlockPos pos, int orientationMeta) {
            this.block = block;
            this.pos = pos;
            this.orientationMeta = orientationMeta;
        }
    }
}

